package commands

import (
	"fmt"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
	"strings"
)

func NewUserInfoCMD() *Command {
	return &Command{
		cmds: []string{"user", "userinfo", "uinfo"},
		name: "User Info",
		description: "Displays a user info card",
		exec: execUserInfoCMD,
		_type:FUN,
	}
}

func execUserInfoCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	if len(args) == 0 {
		s.ChannelMessageEdit(m.ChannelID, m.ID, "Please mention a user")
		return
	}

	user, err := s.User(utils.GetDiscordIDFromMention(args[0]))
	if err != nil {
		s.ChannelMessageEdit(m.ChannelID, m.ID, "Invalid user ID")
		return
	}

	epoch, _ := utils.CreationTime(user.ID)

	mutualFriendData := []string{}
	mutualFriends, _ := s.RelationshipsMutualGet(user.ID)
	for _, friend := range mutualFriends {
		mutualFriendData = append(mutualFriendData, fmt.Sprintf("`%s#%s`", friend.Username, friend.Discriminator))
	}

	emb := utils.NewEmbed().
		SetTitle(fmt.Sprintf("%s#%s - %s", user.Username, user.Discriminator, user.ID)).
		SetColor(utils.RandomColor()).
		AddField("Account Created At", epoch.Format("Mon Jan _2 15:04:05 2006")).
		AddField("Mutual Friends", strings.Join(mutualFriendData, ", "))


	empty := ""
	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content:         &empty,
		Embed:           emb.MessageEmbed,
		ID:              m.ID,
		Channel:         m.ChannelID,
	})

	ret<-CommandRet{}
}