package commands

import (
	"fmt"
	nekos_life "git.quartzinc.dev/Zertex/QuartzSB/nekos.life"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
)

func PatCMD() *Command {
	return &Command{
		cmds: []string{"pat", "pet"},
		name:        "Pat",
		description: "Pats someone you specify!",
		preview:     "https://i.imgur.com/Mlf4uJ1.gif",
		exec:        execPatCMD,
		_type:       FUN,
	}
}

func execPatCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	if len(m.Mentions) < 1 {
		fmt.Println("Sorry but you didn't put any arguments for cmd:pat!")

		emb := utils.
			NewEmbed().
			SetTitle("Error | cmd:pat").
			SetDescription("Sorry you didn't put any arguments").
			SetWatermark(1).
			SetThemecolor()
		empty := ""

		s.ChannelMessageEditComplex(&discordgo.MessageEdit{
			Content: &empty,
			Embed:   emb.MessageEmbed,
			ID:      m.ID,
			Channel: m.ChannelID,
		})

		ret <- CommandRet{}
		return
	}

	var target = m.Mentions[0]

	emb := utils.
		NewEmbed().
		SetTitle(fmt.Sprintf("%s pats %s", m.Author.Username, target.Username)).
		SetImage(nekos_life.SFW_pat())
	empty := ""

	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &empty,
		Embed:   emb.MessageEmbed,
		ID:      m.ID,
		Channel: m.ChannelID,
	})

	ret <- CommandRet{}
}
