package commands

import (
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
	"strings"
)

func L33TCMD() *Command {
	return &Command{
		cmds: []string{"1337", "L33T"},
		name:        "L33T",
		description: "L33T'ify your text input",
		exec:        execL33TCMD,
		_type:       FUN,
	}
}

func execL33TCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	if len(args) == 0 {
		errormsg := utils.L33T_Convert("You didn't put anything to be L33T'ified")
		s.ChannelMessageEditComplex(&discordgo.MessageEdit{
			Content: &errormsg,
			ID:      m.ID,
			Channel: m.ChannelID,
		})
		ret <- CommandRet{}
		return
	}
	converted := utils.L33T_Convert(strings.Join(args, " "))
	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &converted,
		ID:      m.ID,
		Channel: m.ChannelID,
	})
	ret <- CommandRet{}
}
