package commands

import (
	"fmt"
	nekos_life "git.quartzinc.dev/Zertex/QuartzSB/nekos.life"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
)

func KissCMD() *Command {
	return &Command{
		cmds: []string{"kiss"},
		name:        "Kiss",
		description: "Kisses someone you specify!",
		preview:     "https://i.imgur.com/XVyO8Ei.png",
		exec:        execKissCMD,
		_type:       FUN,
	}
}

func execKissCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	if len(m.Mentions) < 1 {
		fmt.Println("Sorry but you didn't put any arguments for cmd:kiss!")

		emb := utils.
			NewEmbed().
			SetTitle("Error | cmd:kiss").
			SetDescription("Sorry you didn't put any arguments").
			SetWatermark(1).
			SetThemecolor()
		empty := ""

		s.ChannelMessageEditComplex(&discordgo.MessageEdit{
			Content: &empty,
			Embed:   emb.MessageEmbed,
			ID:      m.ID,
			Channel: m.ChannelID,
		})

		ret <- CommandRet{}
		return
	}

	var target = m.Mentions[0]

	emb := utils.
		NewEmbed().
		SetTitle(fmt.Sprintf("%s kisses %s", m.Author.Username, target.Username)).
		SetImage(nekos_life.SFW_kiss())
	empty := ""

	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &empty,
		Embed:   emb.MessageEmbed,
		ID:      m.ID,
		Channel: m.ChannelID,
	})

	ret <- CommandRet{}
}
