package commands

import (
	"fmt"
	nekos_life "git.quartzinc.dev/Zertex/QuartzSB/nekos.life"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
)

func HugCMD() *Command {
	return &Command{
		cmds: []string{"hug", "hugs"},
		name:        "Hug",
		description: "Hugs someone you specify!",
		preview:     "https://i.imgur.com/l4xW2Fi.png",
		exec:        execHugCMD,
		_type:       FUN,
	}
}

func execHugCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	if len(m.Mentions) < 1 {
		fmt.Println("Sorry but you didn't put any arguments for cmd:hug!")

		emb := utils.
			NewEmbed().
			SetTitle("Error | cmd:hug").
			SetDescription("Sorry you didn't put any arguments").
			SetWatermark(1).
			SetThemecolor()
		empty := ""

		s.ChannelMessageEditComplex(&discordgo.MessageEdit{
			Content: &empty,
			Embed:   emb.MessageEmbed,
			ID:      m.ID,
			Channel: m.ChannelID,
		})

		ret <- CommandRet{}
		return
	}

	var target = m.Mentions[0]

	emb := utils.
		NewEmbed().
		SetTitle(fmt.Sprintf("%s hugs %s", m.Author.Username, target.Username)).
		SetImage(nekos_life.SFW_hug()).
		SetWatermark(1)
	empty := ""

	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &empty,
		Embed:   emb.MessageEmbed,
		ID:      m.ID,
		Channel: m.ChannelID,
	})

	ret <- CommandRet{}
}
