package commands

import (
	"fmt"
	config "git.quartzinc.dev/Zertex/QuartzSB/config"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
	"math"
	"strconv"
)

func NewHelpCMD() *Command {
	return &Command{
		cmds:         []string {"help", "h", "?"},
		name:        "Help",
		description: "Shows this page",
		exec:        execHelpCMD,
		_type:       UTILITY,
	}
}

func execHelpCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	var maxCmdsPerPage = 9
	pageCount := int(math.Round(float64(len(CommandList) / maxCmdsPerPage)))

	emb := utils.NewEmbed()
	empty := ""

	if len(args) > 0 {
		if i, err := strconv.Atoi(args[0]); err == nil {
			if i == 0 {
				i = 1
			}
			buildHelpPage(emb, i, pageCount)
		} else {
			var cmd *Command
			for _, c := range CommandList {
				if c.IsCmd(args[0]) {
					cmd = c
				}
				if cmd != nil {
					break
				}
			}
			if cmd != nil {
				if config.Watermarking == true {
					emb.SetTitle(fmt.Sprintf("%s | Help ~ %s", config.BotName, cmd.name))
				} else {
					emb.SetTitle(fmt.Sprintf("Help ~ %s", cmd.name))
				}
				emb.SetDescription(fmt.Sprintf("Aliases: %v\nDescription: %s\nUsage: %s", cmd.cmds, cmd.description, ""))
				if cmd.preview != "" {
					emb.SetImage(cmd.preview)
				}
				emb.SetWatermark(1)
			} else {
				emb.SetDescription("Invalid command")
			}
		}
	} else {
		buildHelpPage(emb, 1, pageCount)
	}

	if config.Watermarking == true {
		emb.SetThemecolor()
	} else {
		emb.SetColor(utils.RandomColor())
	}

	emb.SetWatermark(1)

	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &empty,
		Embed:   emb.MessageEmbed,
		ID:      m.ID,
		Channel: m.ChannelID,
	})

	ret <- CommandRet{}
}

func buildHelpPage(emb *utils.Embed, pageNum, pageCount int) {
	if config.Watermarking == true {
		emb.SetTitle(fmt.Sprintf("%s | Help %d/%d", config.BotName, pageNum, pageCount))
	} else {
		emb.SetTitle(fmt.Sprintf("Help %d/%d", pageNum, pageCount))
	}
	if page := paginate(CommandList, (pageNum -1) * 9, 9); len(page) != 0 {
		for _, cmd := range page {
			emb.AddFieldInline(cmd.name, cmd.description)
		}
	} else {
		emb.SetDescription(fmt.Sprintf("No commands on page #%d", pageNum))
	}
}

func paginate(x []*Command, skip int, size int) []*Command {
	if skip > len(x) {
		skip = len(x)
	}

	end := skip + size
	if end > len(x) {
		end = len(x)
	}

	return x[skip:end]
}