package commands

import (
	"fmt"
	config "git.quartzinc.dev/Zertex/QuartzSB/config"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
	libgiphy "github.com/sanzaru/go-giphy"
	"strings"
)

var giphy *libgiphy.Giphy

func init() {
	giphy = libgiphy.NewGiphy(config.GiphyKey)
}

func NewGiphyCMD() *Command {
	return &Command{
		cmds: []string{"giphy", "gif"},
		name:        "Giphy",
		description: "Gets a random gif from giphy",
		preview:     "https://i.imgur.com/JvlI4B3.gif",
		exec:        execGiphyCMD,
		_type:       FUN,
	}
}

func execGiphyCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	search := strings.Join(args, " ")

	emb := utils.NewEmbed().SetTitle(fmt.Sprintf("Here's your random gif for search '%s'", search))

	res, err := giphy.GetSearch(search, -1, -1, "", "", false)
	if err != nil {
		emb.SetDescription("Failed to contact Giphy")
	} else {
		if len(res.Data) > 0 {
			emb.SetImage(res.Data[0].Images.Original.Url)
		} else {
			emb.SetDescription("No search results")
		}
	}

	emb.SetWatermark(1)
	emb.SetThemecolor()

	empty := ""
	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &empty,
		Embed:   emb.MessageEmbed,
		ID:      m.ID,
		Channel: m.ChannelID,
	})

	ret <- CommandRet{}
}
