package commands

import (
	"fmt"
	"github.com/bwmarrin/discordgo"
)

func NewDMControlCMD() *Command {
	return &Command{
		cmds: []string{"dmcontrol", "dmc"},
		name:        "DM Control",
		description: "Open and close your dm's easily",
		exec:        execDMCtrlCMD,
		_type:       UTILITY,
	}
}

func execDMCtrlCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	if len(args) < 1 {
		return
	}

	if guilds, err := s.UserGuilds(100, "", ""); err == nil {
		sett, _ := s.UserSettings()

		if args[0] == "close" {

			var gids []string
			for _, guild := range guilds {
				gids = append(gids, guild.ID)
			}

			sett.RestrictedGuilds = gids
			s.ChannelMessageEdit(m.ChannelID, m.ID, fmt.Sprintf("Closed dm's in %d servers", len(guilds)))
		} else if args[0] == "open" {
			sett.RestrictedGuilds = []string{}
			s.ChannelMessageEdit(m.ChannelID, m.ID, fmt.Sprintf("Opened dm's in %d servers", len(guilds)))
		} else {
			s.ChannelMessageEdit(m.ChannelID, m.ID, "Please choose to either `open` or `close` your dms.")
			return
		}
		s.Request("PATCH", discordgo.EndpointUserSettings("@me"), sett)
	}
}