package commands

import (
	"github.com/bwmarrin/discordgo"
	"strings"
)

type CommandInterface interface {
	Name() string
	Description() string
	Type() int
	Return() chan CommandRet
}

const (
	FUN = iota
	UTILITY
	SPAM
)

type CommandRet struct {
	string
	int
	bool
	error
}

type Command struct {
	cmds        []string
	name        string
	description string
	preview     string
	_type       int
	exec        func(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet)
	ret         chan CommandRet
}

func (c *Command) IsCmd(cmd string) bool {
	for _, cmdd := range c.cmds {
		if strings.ToLower(cmd) == strings.ToLower(cmdd) {
			return true
		}
	}
	return false
}

func FindCmd(cmd string) *Command {
	for _, cmdd := range CommandList {
		if cmdd.IsCmd(cmd) {
			return cmdd
		}
	}
	return nil
}

func (c *Command) Name() string {
	return c.name
}

func (c *Command) Description() string {
	return c.description
}

func (c *Command) Type() int {
	return c._type
}

func (c *Command) Return() chan CommandRet {
	return c.ret
}

func (c *Command) Exec(s *discordgo.Session, m *discordgo.MessageCreate, args []string) {
	c.exec(s, m, args, c.ret)
}

var CommandList []*Command

func init() {
	CommandList = append(CommandList, NewHelpCMD())
	CommandList = append(CommandList, NewClearMessagesCMD())
	CommandList = append(CommandList, NewCockSizeCMD())
	CommandList = append(CommandList, NewIPInfoCMD())
	CommandList = append(CommandList, NewGiphyCMD())
	CommandList = append(CommandList, NewASCIICMD())
	CommandList = append(CommandList, NewEmoteSpamCMD())
	CommandList = append(CommandList, NewBlanketBanCMD())
	CommandList = append(CommandList, NewUserInfoCMD())
	CommandList = append(CommandList, HugCMD())
	CommandList = append(CommandList, PatCMD())
	CommandList = append(CommandList, KissCMD())
	CommandList = append(CommandList, SpankCMD())
	CommandList = append(CommandList, TitsCMD())
	CommandList = append(CommandList, BlankCMD())
	CommandList = append(CommandList, BlankNCMD())
	CommandList = append(CommandList, L33TCMD())
	CommandList = append(CommandList, NewDMControlCMD())
}
