package commands

import (
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
	"log"
	"strconv"
)

func NewClearMessagesCMD() *Command {
	return &Command{
		cmds: []string{"clear", "cls", "nuke"},
		name:        "Clear",
		description: "Clears n count messages",
		exec:        execClearMsgCMD,
		_type:       UTILITY,
	}
}

func execClearMsgCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	s.ChannelMessageDelete(m.ChannelID, m.ID)

	count := 50
	if len(args) > 0 {
		count, _ = strconv.Atoi(args[0])
	}

	i := 0
	lastID := m.ID

	for {
		messages, err := s.ChannelMessages(m.ChannelID, 100, lastID, "", "")
		if err != nil {
			log.Fatal(err.Error())
		}
		for _, msg := range messages {
			if i > count {
				goto done
			}
			if msg.Author.ID == m.Author.ID {
				s.ChannelMessageDelete(msg.ChannelID, msg.ID)
				i++
				utils.RandomDelay()
			}
		}
	}
done:

	ret <- CommandRet{}
}
