package commands

import (
	"fmt"
	"git.quartzinc.dev/Zertex/QuartzSB/discordext"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
)

func BlankNCMD() *Command {
	return &Command{
		cmds: []string{"blanknick", "bnick"},
		name:        "Blank Nickname",
		description: "Blank nickname in server",
		exec:        execBlankNCMD,
		_type:       UTILITY,
	}
}

func execBlankNCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	ch, err1 := s.State.Channel(m.ChannelID)
	if err1 != nil {
		fmt.Println("Error Ref:0m0-1")
	} else if ch.Type == discordgo.ChannelTypeGuildText {
		discordext.SetNickname(s, m.GuildID, discordext.InvisibleNickname)
		emb := utils.NewEmbed().SetDescription("Set nickname to invisible").SetWatermark(1)
		empty := ""
		s.ChannelMessageEditComplex(&discordgo.MessageEdit{
			Content: &empty,
			Embed:   emb.MessageEmbed,
			ID:      m.ID,
			Channel: m.ChannelID,
		})
	}
	ret <- CommandRet{}
}
