package commands

import (
	"fmt"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
)

func NewBlanketBanCMD() *Command {
	return &Command{
		cmds: []string{"blanketban", "bban"},
		name: "Blanket Ban",
		description: "Bans a user in every server you own.",
		exec: execBlanketBanCMD,
		_type:FUN,
	}
}

func execBlanketBanCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	defer func() {
		ret<-CommandRet{}
	}()
	if len(args) == 0 {
		s.ChannelMessageEdit(m.ChannelID, m.ID, "Please @ a user")
		return
	}

	user, err := s.User(utils.GetDiscordIDFromMention(args[0]))
	if err != nil {
		s.ChannelMessageEdit(m.ChannelID, m.ID, "Invalid user")
		return
	}

	guilds, _ := s.UserGuilds(-1, "", "")

	bans := 0

	for _, guild := range guilds {
		if err = s.GuildBanCreate(guild.ID, user.ID, 7); err == nil {
			bans++
		}
	}

	s.ChannelMessageEdit(m.ChannelID, m.ID, fmt.Sprintf("Blanket banned %s from %d servers", user.Username, bans))
}