package commands

import (
	"git.quartzinc.dev/Zertex/QuartzSB/discordext"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
)

func BlankCMD() *Command {
	return &Command{
		cmds: []string{"blankname", "bname"},
		name:        "Blank",
		description: "Sets your PFP to invisible",
		exec:        execBlankCMD,
		_type:       UTILITY,
	}
}

func execBlankCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	discordext.SetAvatar(s, discordext.BlankPNG_Base64)
	empty := ""
	emb := utils.NewEmbed().SetDescription("Set profile picture to invisible").SetWatermark(1)
	s.ChannelMessageEditComplex(&discordgo.MessageEdit{
		Content: &empty,
		Embed:   emb.MessageEmbed,
		ID:      m.ID,
		Channel: m.ChannelID,
	})
	ret <- CommandRet{}
}
