package commands

import (
	"fmt"
	"github.com/bwmarrin/discordgo"
	"io/ioutil"
	"net/http"
	"net/url"
	"strings"
)

// http://artii.herokuapp.com/make?text=ASCII+art

func NewASCIICMD() *Command {
	return &Command{
		cmds: []string{"ascii"},
		name: "Ascii Text",
		description: "Converts regular text to ASCII",
		exec: execAsciiCMD,
		_type:FUN,
	}
}

func execAsciiCMD(s *discordgo.Session, m *discordgo.MessageCreate, args []string, ret chan CommandRet) {
	msg := strings.Join(args, " ")

	u, _ := url.Parse("http://artii.herokuapp.com/make?text=")
	qu := u.Query()
	qu.Set("text", msg)
	u.RawQuery = qu.Encode()

	resp, err := http.Get(u.String())
	if err != nil {
		msg = "Failed to contact Ascii API"
	} else {
		raw, _ := ioutil.ReadAll(resp.Body)
		resp.Body.Close()

		msg = fmt.Sprintf("```\n%s\n```", string(raw))
	}


	s.ChannelMessageEdit(m.ChannelID, m.ID, msg)

	ret<-CommandRet{}
}