package main

import (
	"bufio"
	"fmt"
	"git.quartzinc.dev/Zertex/QuartzSB/commands"
	"git.quartzinc.dev/Zertex/QuartzSB/config"
	"git.quartzinc.dev/Zertex/QuartzSB/sniper"
	"git.quartzinc.dev/Zertex/QuartzSB/utils"
	"github.com/bwmarrin/discordgo"
	"github.com/go-ini/ini"
	screen "github.com/inancgumus/screen"
	"log"
	"os"
	"os/signal"
	"strings"
	"syscall"
)

const TOKEN = "mfa.q67FcdqqEAbLfscJNxdy4DA4x5JTU6DNyKDK1NJDc1fMVPjcm0h39rCJjvxH3nICApr-kt36xxlKVEjzjdZ6"//"NzM1OTM1NTI4MjA5MzUwNzA3.XxnfXw.8xIvGJRxNq7JO6fB8XYuAV7ief0"

var (
	BotObject *discordgo.Session
	err       error
	BotUser   *discordgo.User
)

type Configuration struct {
	Token string
}

func main() {
	/*
		Config loading and creating
	*/
	reader := bufio.NewReader(os.Stdin)
	var config2 *ini.File
	if _, errAccess := os.Stat("config.ini"); errAccess != nil {
		fmt.Println("Insert your token below:")
		tokenLine, _ := reader.ReadString('\n')
		tokenLine = strings.TrimSpace(tokenLine)
		screen.Clear()
		screen.MoveTopLeft()
		var cfg = ini.Empty()
		cfg.Section("").Key("token").SetValue(tokenLine)
		cfg.SaveTo("config.ini")
		config2 = cfg
	} else {
		config2, _ = ini.Load("config.ini")
	}

	/*
		The rest of the magic
	*/
	BotObject, err = discordgo.New(config2.Section("").Key("token").Value())
	if err != nil {
		log.Fatal("Error opening Discord Session")
	}
	defer BotObject.Close()

	BotUser, err = BotObject.User("@me")
	if err != nil {
		fmt.Println(err.Error())
		log.Fatal("Error getting bot user")
	}

	BotObject.AddHandler(commandHandler)
	BotObject.AddHandler(func(s *discordgo.Session, ready *discordgo.Ready) {
		guilds, err := s.UserGuilds(100, "", "")
		if err != nil {
			fmt.Println(err.Error())
			return
		}
		utils.RandomDelay()
		for _, g := range guilds {
			guild, _ := s.Guild(g.ID)
			for _, emoji := range guild.Emojis {
				commands.Emojis = append(commands.Emojis, emoji.MessageFormat())
			}
			utils.RandomDelay()
		}
	})
	BotObject.AddHandler(sniper.Handler)

	err = BotObject.Open()
	if err != nil {
		log.Fatal("error opening connection,", err)
	}
	log.Printf("Welcome! Thank you for using %s !\n", config.BotName)
	log.Printf("The prefix is \"%s\"", config.Prefix)
	log.Printf("Now running. Press CTRL-C to exit.\n")
	sc := make(chan os.Signal, 1)
	signal.Notify(sc, syscall.SIGINT, syscall.SIGTERM, os.Interrupt, os.Kill)
	<-sc

}

func commandHandler(s *discordgo.Session, m *discordgo.MessageCreate) {
	if m.Author.ID != BotUser.ID || !strings.HasPrefix(m.Content, config.Prefix) {
		return
	}

	command := strings.TrimPrefix(m.Content, config.Prefix)
	p := strings.Split(command, " ")
	command = p[0]
	args := p[1:]

	if cmd := commands.FindCmd(command); cmd != nil {
		cmd.Exec(s, m, args)

		<-cmd.Return()
	}
}
