package waf

import (
	"net/http"
	"regexp"
)

func ModSecurity (headers http.Header, str string) bool {
	match1, _ := regexp.MatchString(`(mod_security|Mod_Security|NOYB)`, headers.Get("Server"))
	match2, _ := regexp.MatchString(`This error was generated by Mod.?Security`, str)
	match3, _ := regexp.MatchString(`Protected by Mod.?Security`, str)
	match4, _ := regexp.MatchString(`/modsecurity[\-_]errorpage/`, str)
	match5, _ := regexp.MatchString(`mod.security.rules triggered`, str)
	match6, _ := regexp.MatchString(`rules of the mod.security.module`, str)
	match7, _ := regexp.MatchString(`modsecurity iis`, str)
	
	if match1 || match2 || match3 || match4 || match5 || match6 || match6 || match7 {
		return true
	}
	return false
}