package utils

import (
	"fmt"
	"github.com/fatih/color"
	"time"
)

var logFormat = "[%s] [%s] ~> %s"
const (
	INFO = iota
	WARN
	ERR
)

func LogInfo(msg string) {
	log(msg, INFO)
}

func LogWarning(msg string) {
	log(msg, WARN)
}

func LogError(msg string) {
	log(msg, ERR)
}

func log(msg string, level int) {
	switch level {
	case INFO:
		fmt.Printf(logFormat, color.CyanString("II"), color.MagentaString(time.Now().Format("24:04:05")), color.CyanString(msg))
	case WARN:
		fmt.Printf(logFormat, color.YellowString("!!"), color.MagentaString(time.Now().Format("24:04:05")), color.YellowString(msg))
	case ERR:
		fmt.Printf(logFormat, color.RedString("EE"), color.MagentaString(time.Now().Format("24:04:05")), color.RedString(msg))
	}
}
