package utils

import (
	"bufio"
	"fmt"
	"os"
	"strconv"
	"strings"
	"time"
)
var inputReader *bufio.Reader

func init() {
	inputReader = bufio.NewReader(os.Stdin)
}

func AskYesNo(question string, d bool) bool {
	y := "Y"
	n := "N"
	if d {
		strings.ToLower(n)
	} else {
		strings.ToLower(y)
	}
	fmt.Printf("%s [%s/%s] ", question, y, n)
	answer := strings.ToLower(GetInput())
	if len(answer) == 0 {
		return d
	}

	if answer == "y" || answer == "yes" {
		return true
	}
	return false
}

func AskInteger(question string, d int) int {
	for {
		fmt.Printf("%s [%d]", question, d)
		answer, err := strconv.Atoi(GetInput())
		if err != nil {
			LogError("Invalid entry!")
			time.Sleep(1000 * time.Millisecond)
			continue
		}

		return answer
	}
}

func CleanInput(input string) string {
	return strings.ReplaceAll(strings.ReplaceAll(input, "\r", ""), "\n", "")
}

func GetInput() string {
	s, _ := inputReader.ReadString('\n')
	return CleanInput(s)
}