package manager

import (
	"bufio"
	"fmt"
	"math/rand"
	"net/http"
	"net/url"
	"os"
	"strings"
	"time"
)

type ProxyManager struct {
	Proxies []*Proxy
	Client http.Client
}

func NewProxyManager() *ProxyManager {
	return &ProxyManager{
		Proxies: make([]*Proxy, 0),
		Client:  http.Client{},
	}
}

func (pm *ProxyManager) CreateScrapeTransport() *http.Transport {

}

func (pm *ProxyManager) GetRandomProxy() *Proxy {
	switch len(pm.Proxies) {
	case 0:
		return nil
	case 1:
		return pm.Proxies[0]
	default:
		return pm.Proxies[rand.Intn(len(pm.Proxies)-1)]
	}
}

func (pm *ProxyManager) Load(filename string, ptype int, forChecking bool) error {
	f, err := os.Open(filename)
	if err != nil {
		return err
	}
	var scheme string
	switch ptype {
	case HTTP:
		scheme = "http"
	case SOCKS4:
		scheme = "socks4"
	case SOCKS5:
		scheme = "socks5"
	}

	scanner := bufio.NewScanner(f)
	for scanner.Scan() {
		p := Proxy{
			Type:         ptype,
			Alive:        !forChecking,
		}
		str := ""
		if strings.Count(scanner.Text(), ":") == 3 {
			parts := strings.Split(scanner.Text(), ":")
			str = fmt.Sprintf("%s://%s:%s@%s:%s", scheme, parts[2], parts[3], parts[0], parts[1])
		} else {
			str = fmt.Sprintf("%s://%s", scheme, scanner.Text())
		}

		u, err := url.Parse(str)
		if err != nil {
			continue
		}
		p.Url = u
		pm.Proxies = append(pm.Proxies, &p)
	}
	return nil
}

func (pm *ProxyManager) Reset() {
	for _, p := range pm.Proxies {
		p.Alive = true
	}
}

const (
	HTTP = iota
	SOCKS4
	SOCKS5
)

type Proxy struct {
	Url *url.URL
	Type int
	Alive bool
	ResponseTime time.Duration
}

func (p *Proxy) ToUrlFunc() func(r *http.Request) (*url.URL, error) {
	return func(r *http.Request) (*url.URL, error) {
		return p.Url, nil
	}
}