package main

import (
	"fmt"
	"git.quartzinc.dev/Zertex/qprox/manager"
	"git.quartzinc.dev/Zertex/qprox/shared"
	"git.quartzinc.dev/Zertex/qprox/utils"
	"github.com/fatih/color"
	"github.com/sqweek/dialog"
)

var ProxyManager *manager.ProxyManager

func init() {
	color.Magenta(shared.Banner)
	ProxyManager = manager.NewProxyManager()
}

func main() {
	utils.LogInfo("QProx.io Scraper - Developed by Zertex#0003\r\n")

	if utils.AskYesNo("Do you want to use proxies?", true) {
		utils.LogInfo("Please Choose your proxy file.")
		filename, err := dialog.File().Filter("XML files", "xml").Title("Export to XML").Save()
		if err != nil {
			utils.LogError(fmt.Sprintf("FATAL: %s", err.Error()))
			return
		}

	}


}