<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use function foo\func;

Auth::routes();

Route::get('/', 'HomeController@index')->name('home');

Route::get('/product/{id}', 'ProductController@viewProduct')->name('product.view');
Route::get('/category/{name}', 'HomeController@category')->name('category');
Route::get('/vendor/{name}', 'HomeController@vendor')->name('vendor');

Route::prefix('profile')->group(function () {
    Route::get('/', 'Profile@index')->name('profile');
    Route::post('/save', 'Profile@save')->name('profile.save');
    Route::post('/avatar', 'Profile@uploadAvatar')->name('profile.avatar');
});

Route::prefix('orders')->group(function () {
    Route::get('/', 'OrderController@index')->name('orders');
    Route::get('/{uuid}/view', 'OrderController@view')->name('orders.view');
    Route::get('/{uuid}/cancel', 'OrderController@cancel')->name('orders.cancel');
    Route::get('/{id}', 'OrderController@confirm')->name('orders.confirm');
    Route::post('/{id}', 'OrderController@place')->name('orders.place');
});

Route::prefix('disputes')->group(function () {
    Route::get('/', 'DisputeController@index')->name('disputes');
    Route::post('/open', 'DisputeController@open')->name('disputes.open');
});

Route::get('/2fa', 'PGPController@index')->name('2fa');
Route::post('/2fa', 'PGPController@verify')->name('2fa.verify');


Route::prefix('vcp')->group(function () {
    Route::get('/', 'VendorController@index')->name('vendor.home');
    Route::prefix('products')->group(function () {
        Route::get('/', 'VendorController@products')->name('vendor.products');
        Route::get('/{uuid}', 'VendorController@edit')->name('vendor.products.edit');
        Route::post('/{uuid}/save', 'VendorController@save')->name('vendor.products.save');
        Route::post('/{uuid}/delete', 'VendorController@delete')->name('vendor.products.delete');
    });
    Route::prefix('orders')->group(function () {
        Route::get('/', 'VendorController@orders')->name('vendor.orders');
        Route::get('/{uuid}', 'VendorController@order_view')->name('vendor.orders.view');
        Route::post('/{uuid}', 'VendorController@order_update')->name('vendor.orders.update');
    });
});