@extends('layouts.vendor')

@section('breadcrumb')
    <li class="breadcrumb-item active">Products</li>
@endsection

@section('content2')
<table class="table table-striped">
    <thead>
        <tr>
            <th scope="col">
                Product name
            </th>
            <th scope="col">
                Average user rating
            </th>
            <th scope="col" style="width: 10rem">
                Utilities
            </th>
        </tr>
    </thead>
    <tbody>
        @foreach($products as $product)
            <tr>
                <th scope="col">
                    {{ $product->name }}
                </th>
                <td>
                    @include('partials.ratingstars', ['rating' => $product->getRating()]) {{$product->getRating()}}/5
                </td>
                <td>
                    <a href="{{ route('product.view', $product->uuid) }}"><button class="btn btn-info"><i class="fas fa-share-square"></i></button></a>
                    <a href="{{ route('vendor.products.edit', $product->uuid) }}"> <button class="btn btn-warning"><i class="fas fa-edit"></i></button></a>
                    <button class="btn btn-danger" type="submit" form="del-{{$product->uuid}}"><i class="fas fa-trash-alt"></i></button>
                    <form action="{{ route('vendor.products.delete', $product->uuid) }}" method="POST" id="del-{{$product->uuid}}">
                        @csrf
                    </form>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
    <div class="align-bottom">
        {{ $products->links() }}
    </div>
@endsection