@extends('layouts.vendor')

@section('breadcrumb')
    <li class="breadcrumb-item active" aria-current="page">Orders</li>
@endsection

@section('content2')
<table class="table table-striped">
    <thead>
        <tr>
            <th scope="col">
                Order ID
            </th>
            <th scope="col">
                Product
            </th>
            <th scope="col">
                Status
            </th>
            <th scope="col">
                Utilities
            </th>
        </tr>
    </thead>
    <tbody>
        @foreach($orders as $order)
            <tr>
                <th scope="col">
                    <a href="{{route('vendor.orders.view', $order->uuid)}}">{{ $order->uuid }}</a>
                </th>
                <td>
                    <a href="{{ route('product.view', $order->product()->uuid) }}">{{ $order->product()->name }}</a>
                </td>
                <td>
                    {{ $order->getStatusMessage() }}
                </td>
                <td>
                    stuff
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
@endsection