@extends('layouts.vendor')

@section('breadcrumb')
    <li class="breadcrumb-item" aria-current="page"><a href="{{ route('vendor.products') }}">Products</a> </li>
    <li class="breadcrumb-item active" aria-current="page">Edit Product</li>
@endsection

@section('content2')
<form action="{{ route('vendor.products.save', $product->uuid) }}" method="POST" enctype="multipart/form-data">
    @csrf
    <div class="row">
        <div class="col-md-6">
            <div class="row">
                <div class="col-sm-5">
                    <img src="{{ $product->image() }}" width="150px" height="150px">
                </div>
                <div class="col-sm-7 align-self-end">
                    <div class="form-group">
                        <label for="avatar" class="form-control-plaintext">Select Avatar</label>
                        <input id="avatar" name="avatar" class="form-control-file" type="file">
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="prod_name" class="form-control-plaintext">Product name</label>
                <input id="prod_name" name="prod_name" class="form-control" type="text" value="{{ $product->name }}">
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="form-group">
                <label for="prod_price" class="form-control-plaintext">Product price</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input class="form-control" id="prod_price" name="prod_price" type="number" value="{{ $product->price }}">
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="form-group">
                <label for="prod_description" class="form-control-plaintext">Product Description</label>
                <textarea id="prod_description" class="form-control" name="prod_description">{{ $product->description }}</textarea>
            </div>
        </div>
    </div>
    <div class="row">
        <span class="d-inline">
            <button class="btn btn-success" type="submit">Save</button>
            <a href="{{ route('vendor.products') }}"><button class="btn btn-danger">Cancel</button></a>
        </span>
    </div>
</form>
@endsection