@extends('layouts.app')

@section('breadcrumbs')
    <li class="breadcrumb-item active" aria-current="page">Profile</li>
@endsection

@section('content')
<div class="col-md-12">
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Whoops!</strong> There were some problems with your input.
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <div class="card">
        <div class="card-header">
            <span class="card-title">{{ Auth::user()->username }}</span>
        </div>
        <div class="card-body">
            <div class="row flex-fill">
                <div class="col-md-2">
                    <img src="{{ 'images/'.Auth::user()->avatar }}" alt="avatar" width="100px" height="100px">
                </div>
                <div class="col-md-10">
                    <form method="POST" action="{{ route('profile.avatar') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group">
                            <label for="avatar" class="form-control-plaintext">Select Avatar</label>
                            <input id="avatar" name="avatar" class="form-control-file" type="file">
                        </div>
                        <button class="form-control" type="submit">Upload</button>
                    </form>
                </div>
            </div>
            <br/>
            <form method="POST" action="{{ route('profile.save') }}">
                @csrf
                <div class="input-group">
                    <div class="input-group-prepend">
                        <label class="input-group-text" for="currency">Preferred Currency</label>
                    </div>
                    <select class="custom-select" id="currency" name="currency">
                        <option value="{{ \Auth::user()->currency }}" selected>{{ \Auth::user()->currency }}</option>
                        @foreach($currencies as $currency)
                            @if ($currency != \Auth::user()->currency)
                                <option value="{{ $currency }}">{{ $currency }}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
                <br/>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <label class="input-group-text" for="motd">MOTD</label>
                    </div>
                    <textarea class="form-control" id="motd" name="motd">{{ Auth::user()->motd }}</textarea>
                </div>
                <br/>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <label class="input-group-text" for="pgp">PGP Key</label>
                    </div>
                    <textarea class="form-control" id="pgp" name="pgp">{{ Auth::user()->pgp }}</textarea>
                </div>
                <br/>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <label class="input-group-text" for="btc">BTC return address</label>
                    </div>
                    <input class="form-control" type="text" id="btc" name="btc" value="{{ Auth::user()->btc }}">
                </div>
                <br/>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <label class="input-group-text" for="xmr">XMR return address</label>
                    </div>
                    <input class="form-control" type="text" id="xmr" name="xmr" value="{{ Auth::user()->xmr }}">
                </div>
                <br/>
                <button type="submit" class="btn btn-success">Save</button>
            </form>
        </div>
    </div>
</div>
@endsection