@extends('layouts.app')

@section('breadcrumbs')
    <li class="breadcrumb-item active" aria-current="page">Orders</li>
@endsection

@section('content')
<div class="card w-100">
    <div class="card-header">
        <div class="card-title">Your Orders <i class="fas fa-box-open"></i></div>
    </div>
    <div class="card-body">
        @if(count($orders) > 0)
        <table class="table table-responsive-lg table-striped">
            @foreach($orders as $order)
                <tr>
                    <th style="width: 150px;">
                        <img src="{{ $order->product()->image() }}" width="150px">
                    </th>
                    <td style="width: 240px">
                        <a href="{{ route('product.view', $order->product()->uuid) }}"><span class="card-text">{{ $order->product()->name }}</span></a>
                        <br/>
                        <span class="card-text">Ordered: {{ $order->getCreatedDiff() }}</span>
                        <br/>
                        <span class="card-text">Updated: {{ $order->getUpdatedDiff() }}</span>
                    </td>
                    <td>
                        <a href="{{ route('orders.view', $order->uuid) }}">{{ $order->uuid }}</a>
                        <br/>
                        <span class="card-text" style="background-color: {{ $order->getStatusColor() }}">&nbsp;&nbsp;{{ $order->getStatusMessage() }}&nbsp;&nbsp;</span>
                        <br/>
                         {{ $order->getPriceFiat().' '.$order->price_crypto }}
                    </td>
                    <td>
                        <a href="{{ route('orders.cancel', $order->uuid) }}"><button class="btn btn-danger" type="submit" @if($order->status != 0) disabled @endif>Cancel</button></a>
                    </td>
                </tr>
            @endforeach
        </table>
        @else
        <span>No current orders, go buy something!</span>
        @endif
    </div>
</div>
@endsection