@extends('layouts.app')

@section('breadcrumbs')
    <li class="breadcrumb-item"><a href="{{route('orders')}}">Orders</a></li>
    <li class="breadcrumb-item active">Order {{ $order->uuid }}</li>
@endsection

@section('content')
    <div class="col-md-12">
        <div class="well">
            <h4>Order {{ $order->uuid }} status:</h4>

            <ul class="list-group">
                <li class="list-group-item">
                    <span class="prefix">Date created:</span>
                    <span class="label label-success">{{ $order->created_at }}</span>
                </li>
                <li class="list-group-item">
                    <span class="prefix">Last update:</span>
                    <span class="label label-success">{{ $order->updated_at }}</span>
                </li>
                <li class="list-group-item">
                    <span class="prefix">Comment:</span>
                    <br/>
                    <samp>{{ $order->getFirstComment()->message }}</samp>
                </li>
                <li class="list-group-item">
                    <div class="order-status">
                        <span>{{ $order->getStatusMessage() }}</span>
                        <div class="progress">
                            <div class="progress-bar progress-bar-striped {{ $order->getStatusBG() }}" role="progressbar" style="width: {{ $order->getStatusPercent() }}%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </li>
                <li class="list-group-item">
                    <a href="{{ route('orders.cancel', $order->uuid) }}"><button class="btn btn-danger" @if($order->status != 0) disabled @endif>Cancel</button></a>
                    <button class="btn btn-warning" @if($order->status == -1) disabled @endif type="submit" form="dispute_form">Dispute</button>
                    <form action="{{ route('disputes.open') }}" method="POST" name="dispute_form" id="dispute_form">
                        @csrf
                        <input type="text" hidden value="{{ $order->uuid }}" name="order_uuid">
                    </form>
                </li>
            </ul>
        </div>
    </div>
@endsection