@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-md-4 order-md-2 mb-4">
        <div class="card">
            <div class="card-header">
                <img src="{{ $product->image() }}" class="card-img-top">
            </div>
            <div class="card-body">
                <a href="{{ route('product.view', $product->id) }}"><span class="card-text">{{ $product->name }}</span></a>
                <p class="card-text">
                    @include('partials.ratingstars', ['rating' => $product->getRating()])
                </p>
                <p class="card-text">
                    1x {{ $product->getCost(\Auth::user()->currency) }}
                </p>

            </div>
            <div class="card-footer">
                <button class="btn btn-success" type="submit" form="confirm_form">Submit Order</button>
            </div>
        </div>
    </div>
    <div class="col-md-8 order-md-1">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Order confirmation
                </div>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('orders.place', $product->id) }}" id="confirm_form" name="confirm_form">
                    @csrf
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">Quantity</span>
                        </div>
                        <input type="number" id="quantity" name="quantity" class="form-control">
                    </div>
                    <br/>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">Message to vendor</span>
                        </div>
                        <textarea type="text" class="form-control" name="message"></textarea>
                    </div>
                    <small>Please be sure to encrypt any sensitive information, like your address! <a href="{{ route('vendor', $product->vendor()->username) }}">Get their PGP key here</a> </small>
                    <br/>
                    <div class="input-group">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="cryptoRadios" id="radioBtc" value="0" @if($product->getAllowedCrypto() == 1) disabled @endif>
                            <label class="form-check-label" for="radioBtc">BTC</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="cryptoRadios" id="radioXmr" value="1" @if($product->getAllowedCrypto() == 0) disabled @endif>
                            <label class="form-check-label" for="radioBtc">XMR</label>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection