@extends('layouts.app')

@section('breadcrumbs')
    @if(\Route::currentRouteName() == 'vendor.home')
        <li class="breadcrumb-item">Vendor Dashboard</li>
    @else
        <li class="breadcrumb-item active"><a href="{{ route('vendor.home') }}">Vendor Dashboard</a></li>
    @endif
    @yield('breadcrumb')
@endsection

@section('content')
    <div class="card w-100">
        <div class="card-header">
            <span class="card-title">Your catalog</span>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-3">
                    <div class="list-group">
                        <a href="{{ route('vendor.home') }}" class="list-group-item @if(\Route::currentRouteName() == 'vendor.home') active @endif">Dashboard</a>
                        <a href="{{ route('vendor.products') }}" class="list-group-item @if(\Route::currentRouteName() == 'vendor.products') active @endif">Products</a>
                        <a href="{{ route('vendor.orders') }}" class="list-group-item @if(\Route::currentRouteName() == 'vendor.orders') active @endif">Orders</a>
                    </div>
                </div>
                <div class="col-md-9">
                    @yield('content2')
                </div>
            </div>
        </div>
    </div>
@endsection