<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Venezia</title>

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body>
    <div id="app">
        <nav class="navbar navbar-expand-md navbar-light bg-white shadow-sm">
            <div class="container">
                <a class="navbar-brand" href="{{ route('home') }}">
                    {{ config('app.name', 'Venezia') }}
                </a>

                @if(\Route::currentRouteName() != '2fa')
                    @auth

                        <ul class="navbar-nav mr-auto">
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('home') }}"><i class="fas fa-home"></i> Home</a>
                            </li>
                            @if(\Auth::user()->role()->first()->id == 1)
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('orders') }}"><i class="fas fa-boxes"></i> Orders @if(\Auth::user()->orders()->whereNotIn('status', [-1])->count() > 0)<span class="badge badge-info">{{\Auth::user()->orders()->count()}}</span>@endif </a>
                                </li>
                            @elseif(\Auth::user()->role()->first()->id == 2)
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ route('vendor.home') }}"><i class="fas fa-boxes"></i> Shop</a>
                                </li>
                            @endif
                        </ul>
                    @endauth
                @endif

                <ul class="navbar-nav ml-auto">
                    <li class="nav-item">
                        <span class="navbar-text">Server Time: {{ \Carbon\Carbon::now() }}</span>
                    </li>

                    @guest
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                        </li>
                        @if (Route::has('register'))
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                            </li>
                        @endif
                    @endguest
                    @auth
                        <li class="nav-item">
                            <a class="nav-link" href="{{route('profile')}}">
                               Welcome, {{ Auth::user()->username }}
                            </a>
                        </li>
                        <li class="nav-item">
                            <button class="btn btn-danger" type="submit" form="logout-form">
                                {{ __('Logout') }}
                            </button>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST">
                                @csrf
                            </form>
                        </li>
                    @endauth
                </ul>
            </div>
        </nav>

        <main class="py-4">
            <div class="container">
                <div class="row mb-3 justify-content-center align-items-start w-100">
                    @if ($message = Session::get('success'))
                        <div class="alert alert-success alert-block">
                            <strong>{{ $message }}</strong>
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if ($message = Session::get('error'))
                        <div class="alert alert-danger alert-block">
                            <strong>{{ $message }}</strong>
                        </div>
                    @endif
                </div>

                @auth
                <div class="row">
                    <nav class="w-100" aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            @if(\Route::currentRouteName() == 'home')
                                <li class="breadcrumb-item active">Home</li>
                            @else
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                                @yield('breadcrumbs')
                            @endif
                        </ol>
                    </nav>
                </div>
                @endauth
                <div class="row mb-3 justify-content-center align-items-center">
                    @yield('content')
                </div>
            </div>
        </main>

        <footer class="footer fixed-bottom" style="padding-bottom: 10px">
            <div class="container">
                <span class="text-muted">Created with love for the community.</span>
            </div>
        </footer>
    </div>
</body>
</html>
