@extends('layouts.app')

@section('breadcrumbs')
    <li class="breadcrumb-item active">{{ $sidebarHeader }}</li>
@endsection

@section('content')
    <!-- begin sidebar -->
    <div class="col-md-4 align-self-start">
        <div class="list-group">
            @if(isset($sidebar_items) && $sidebar_items != null)
                <span href="#" class="list-group-item">
                    {{ $sidebarHeader }}
                </span>
                @foreach($sidebar_items as $item)
                    <a href="{{route('category', $item->name)}}" class="list-group-item">
                        {{ $item->name }} <span class="badge">{{ $item->count_including_children() }}</span>
                    </a>
                @endforeach
            @else
                <span href="#" class="list-group-item">
                    <div class="row">
                        <div class="col-md-6">
                            <img src="{{ '/images/'.$vendor_info->avatar }}" alt="Vendor PFP" width="150">
                        </div>
                        <div class="col-md-6">
                            {{ $sidebarHeader }}
                            <br/>
                            <p style="background-color: #02BC0B; width: 4rem">&nbsp;&nbsp;Level 0  </p>
                            @if($vendor_info->trusted)
                                <p style="background-color: #1cd564;width: 6rem;">&nbsp;&nbsp;Trusted <i class="fas fa-star"></i></p>
                            @else
                                <p style="background-color: #135de3;width: 6rem;">&nbsp;&nbsp;Untrusted <i class="far fa-star"></i></p>
                            @endif
                        </div>
                    </div>
                </span>
                <span href="#" class="list-group-item">
                    {{ $vendor_info->motd }}
                </span>
                <span href="#" class="list-group-item">
                    <div class="row">
                        <div class="col-md-6">
                            <p>Average Rating {{ $vendor_info->getAverageRatings() }}</p>
                            @include('partials.ratingstars', ['rating' => $vendor_info->getAverageRatings()])
                        </div>
                        <div class="col-md-6">
                            Products listed: {{ $vendor_info->products()->count() }}
                        </div>
                    </div>
                </span>
                <span href="#" class="list-group-item">
                    <pre>{{ $vendor_info->pgp }}</pre>
                </span>
            @endif
        </div>
        <br/>
        <div class="list-group">
            <span href="#" class="list-group-item">
                Bitcoin {{ $btc_price_ticker }}
            </span>
        </div>
    </div>
    <!-- end sidebar -->
    <div class="col-md-8">
        <table class="table table-responsive-xl table-striped">
            <tbody>
                @foreach($products as $product)
                    <tr> <!-- Begin product -->
                        <th scope="col" style="width: 190px">
                            <img src="{{ '/images/'.$product->img }}" alt="Product Image" width="180">
                        </th>
                        <td>
                            <div class="text-center">
                                <a href="{{ route('product.view', $product->id) }}">{{ $product->name }}</a>
                                <br/>
                                {{ $product->getCost(\Auth::user()->currency) }}
                                <br/>
                                <small>{{ $product->getCryptoCost(\Auth::user()->currency) }}</small>
                                <br/>
                                <a href="{{ route('orders.confirm', $product->id) }}"><button class="btn btn-success">Buy Now</button></a>
                            </div>
                        </td>
                        <td>
                            <a href="{{ route('vendor', $product->vendor()->username) }}">{{ $product->vendor()->username }}</a>
                            <br/>
                            Average ratings {{ ($product->vendor()->getAverageRatings()/5)*100 }}%
                            <br/>
                            @include('partials.ratingstars', ['rating'=>$product->getRating()])
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <div class="align-bottom position-absolute">
            {{ $products->links() }}
        </div>
    </div>
@endsection
