<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('username')->unique();
            $table->string('avatar')->default("ava.png");
            $table->text('pgp');
            $table->integer('pin');
            $table->string('password');
            $table->string('currency', 3)->default('USD');
            $table->boolean('trusted')->default(false);
            $table->string('btc')->nullable();
            $table->string('xmr')->nullable();
            $table->text('motd')->nullable();
            $table->string('token')->nullable();
            $table->dateTime('token_expiry')->default(\Carbon\Carbon::now());
            $table->unsignedBigInteger('role_id')->default(1);
            $table->rememberToken();
            $table->timestamps();

            $table->foreign('role_id')->references('id')->on('roles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
