<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username', 'password', 'pgp', 'pin', 'currency'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function ratings() {
        return \DB::table('ratings')->where('user_id', $this->id)->get();
    }

    public function orders() {
        return $this->hasMany('App\Order');
    }

    public function role() {
        return $this->belongsTo('App\Role');
    }

    public function getAverageRatings() {
        $a = 0.0;
        $ratings = $this->ratings();
        foreach ($ratings as $rating) {
            $a += $rating->rating;
        }
        if (count($ratings) == 0)
            return 0;
        $a /= count($ratings);
        return $a;
    }

    public function products() {
        return $this->hasMany('App\Product', 'vendor_id');
    }
}
