<?php

namespace App;

use Akaunting\Money\Currency;
use Akaunting\Money\Money;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Product extends Model
{
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->uuid = (string) Str::uuid();
        });
    }

    protected $fillable = [
        'name', 'description', 'price', 'vendor_id', 'category_id', 'fiat'
    ];

    public function category() {
        return $this->belongsTo('App\Category')->get();
    }

    public function vendor() {
        return $this->belongsTo('App\User', 'vendor_id')->first();
    }

    public function ratings() {
        return \DB::table('ratings')->where('product_id', $this->id)->get();
    }

    public function getAllowedCrypto() {
        $vendor = $this->vendor();
        $i = -1;
        if(strlen($vendor->btc) > 0)
            $i++;
        if(strlen($vendor->xmr) > 0)
            $i+=2;
        return $i;
    }

    public function getRating() {
        $a = 0.0;
        $ratings = $this->ratings();
        foreach ($ratings as $rating) {
            $a += $rating->rating;
        }
        if (count($ratings) == 0)
            return 0;
        return $a / count($ratings);
    }

    public function image() {
        return '/images/'.$this->img;
    }

    public function getCost($currency) {
        return new Money($this->getCostBase($currency), new Currency($currency), true);
    }

    public function getCostBase($currency) {
        $price = $this->price;
        if ($this->fiat != $currency) {
            $btc_usd = PriceTicker::where('crypto', 0)->where('code', "USD")->first();
            $btc_fiat = PriceTicker::where('crypto', 0)->where('code', $currency)->first();
            $price *= $btc_fiat->value/$btc_usd->value;
        }
        return $price;
    }

    public function getCryptoCost($currency) {
        $ticker = PriceTicker::where('crypto', 0)->where('code', $currency)->first();
        return $this->getCostBase($currency)/$ticker->value;
    }
}
