<?php

namespace App;

use Akaunting\Money\Currency;
use Akaunting\Money\Money;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Order extends Model
{
    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub

        static::creating(function ($model) {
            $model->uuid = (string) Str::uuid();
        });
    }

    protected $fillable = [
        'user_id', 'product_id', 'price_crypto', 'price_fiat', 'crypto_type', 'address', 'fiat', 'quantity'
    ];

    public function product() {
        return $this->belongsTo('App\Product')->first();
    }

    public function comments() {
        return $this->hasMany('App\Message');
    }

    public function getFirstComment() {
        return $this->comments()->first();
    }

    public function getStatusColor() {
        $style = "";
        switch ($this->status) {
            case -1 :
                $style = "#ff6666";
                break;
            case 0:
                $style = "#7886d7";
                break;
            case 1:
                $style = "#385d7a";
                break;
            case 2:
                $style = "#2ca02c";
                break;
            case 3:
                $style = "#747474";
                break;
        }
        return $style;
    }

    public function getStatusPercent() {
        $style = 0;
        switch ($this->status) {
            case -1 :
                $style = 0;
                break;
            case 0:
                $style = 15;
                break;
            case 1:
                $style = 50;
                break;
            case 2:
                $style = 75;
                break;
            case 3:
                $style = 100;
                break;
        }
        return $style;
    }

    public function getStatusMessage() {
        $style = "";
        switch ($this->status) {
            case -1:
                $style = "Canceled";
                break;
            case 0 :
                $style = "Waiting on payment";
                break;
            case 1:
                $style = "Vendor is getting your order ready.";
                break;
            case 2:
                $style = "Order shipped!";
                break;
            case 3:
                $style = "Order completed.";
                break;
        }
        return $style;
    }

    public function getPriceFiat () {
        return new Money($this->price_fiat, new Currency($this->fiat), true);
    }

    public function getCreatedDiff() {
        return $this->created_at->diffForHumans(\Carbon\Carbon::now(), \Carbon\CarbonInterface::DIFF_RELATIVE_TO_NOW);
    }

    public function getUpdatedDiff() {
        return $this->updated_at->diffForHumans(\Carbon\Carbon::now(), \Carbon\CarbonInterface::DIFF_RELATIVE_TO_NOW);
    }

    public function getStatusBG() {
        switch ($this->status) {
            case -1:
                return 'bg-danger';
            case 0:
                return 'bg-warning';
            case 1:
                return 'bg-info';
            case 2:
                return 'bg-success';
            case 3:
                return '';
        }
    }
}
