<?php

namespace App\Http\Controllers;

use App\Order;
use App\Product;
use Illuminate\Http\Request;

class VendorController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'pgp']);
    }

    public function index() {
        return view('vendor.dashboard');
    }

    public function products() {
        $products = \Auth::user()->products()->paginate(12);
        return view('vendor.products', ['products' => $products]);
    }

    public function edit($uuid) {
        $product = Product::where('uuid', $uuid)->first();
        return view('vendor.edit_product', ['product' => $product]);
    }

    public function orders() {
        $orders = Order::where('vendor_id', \Auth::user()->id)->get();
        return view('vendor.orders', ['orders' => $orders]);
    }

    public function save($uuid) {
        request()->validate([

        ]);
        $product = Product::where('uuid',$uuid)->first();

    }

    public function delete($uuid) {
        Product::where('uuid', $uuid)->first()->delete();
        return back()->with('success', 'Product deleted successfully!');
    }
}
