<?php

namespace App\Http\Controllers;

use App\PriceTicker;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Imagick;

class Profile extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'pgp']);
    }

    public function index()
    {
        $currencies = PriceTicker::where('crypto',0)->pluck('code');
        return view('profile', ['currencies' => $currencies]);
    }

    public function uploadAvatar()
    {
        request()->validate([
            'avatar' => 'required|image|mimes:jpeg,png,jpg|max:2048',
        ]);

        $imageName = time().'.'.request()->avatar->getClientOriginalExtension();

        request()->avatar->move(public_path('images'), $imageName);

        $img = new Imagick(public_path('images').'/'.$imageName);
        $img->stripImage();
        $img->writeImage(public_path('images').'/'.$imageName);

        \Auth::user()->avatar = $imageName;
        \Auth::user()->save();

        return back()
            ->with('success','Updated avatar picture.');
    }

    public function save() {
        request()->validate([
            'motd' => 'string|max:255|nullable',
            'btc' => 'string|min:25|max:34|nullable',
            'xmr' => 'string|min:95|max:106|nullable',
            'pgp' => 'string|required',
            'currency' => 'string|required'
        ]);
        if (isset(request()->motd))
            \Auth::user()->motd = request()->motd;
        if (isset(request()->btc))
            \Auth::user()->btc = request()->btc;
        if (isset(request()->xmr))
            \Auth::user()->xmr = request()->xmr;
        if (\Auth::user()->pgp != request()->pgp) {

        }
        \Auth::user()->currency = request()->currency;
        \Auth::user()->save();
        return back()
            ->with('success', 'Updated settings!');
    }

    public function vendor($id) {

        return view('vendor');
    }
}
