<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class PGPController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $gpg = new \gnupg();
        $info = $gpg->import(\Auth::user()->pgp);
        $gpg->setarmor(1);
        $gpg->addencryptkey($info['fingerprint']);
        $enc = $gpg->encrypt(\Auth::user()->token);

        return view('auth.verify', ['armored_text' => $enc]);
    }

    public function verify(Request $request) {
        $request->validate([
            '2fa' => 'required',
        ]);

        if ($request->input('2fa') == \Auth::user()->token) {
            \Auth::user()->token_expiry = \Carbon\Carbon::now()->addHour();
            \Auth::user()->save();
            return redirect(route('home'))->with('success', 'Welcome back, '.\Auth::user()->username);
        } else {
            info("not good");
            return redirect(route('2fa'))->with('error', 'Invalid token');
        }
    }
}
