<?php

namespace App\Http\Controllers;

use App\Message;
use App\Order;
use App\Product;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function __construct()
    {
        $this->middleware(['auth', 'pgp']);
    }

    public function index() {
        $orders = \Auth::user()->orders()->get();

        return view('orders', ['orders' => $orders]);
    }

    public function place($product_id) {
        request()->validate([
            'quantity' => 'required|integer',
            'message' => 'nullable|string|max:1024',
            'cryptoRadios' => 'required|in:0,1'
        ]);
        $product = Product::where('id', $product_id)->first();
        $address = bitcoind()->getNewAddress();
        $cur = \Auth::user()->currency;
        $order = Order::create([
            'user_id' => \Auth::user()->id,
            'product_id' => $product_id,
            'price_crypto' => $product->getCryptoCost($cur),
            'price_fiat' => $product->getCostBase($cur),
            'crypto_type' => request()->input('cryptoRadios', 0),
            'fiat' => $cur,
            'address' => $address,
            'quantity' => request()->input('quantity', 1)
        ]);
        $order->save();

        if (strlen(request()->input('message', '')) > 0) {
            $message = Message::create([
                'order_id' => $order->id,
                'user_id' => \Auth::user()->id,
                'message' => request()->input('message')
            ]);
            $message->save();
        }

        return redirect(route('orders.view', $order->uuid));
    }

    public function confirm($product_id) {
        $product = Product::where('id', $product_id)->first();
        return view('order_confirm', ['product' => $product]);
    }

    public function view($uuid) {
        $order = Order::where('uuid', $uuid)->first();
        return view('order_view', ['order' => $order]);
    }

    public function cancel($uuid) {
        $order = Order::where('uuid', $uuid)->first();
        $order->status = -1;
        $order->save();
        return redirect(route('orders'))->with('success', 'Order canceled');
    }
}
