<?php

namespace App\Http\Controllers;

use Akaunting\Money\Currency;
use Akaunting\Money\Money;
use App\Category;
use App\PriceTicker;
use App\Product;
use App\User;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(['auth', 'pgp']);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $categories = Category::where('parent', 0)->get();
        $products = Product::paginate(30);
        $btc_ticker = PriceTicker::where('crypto', 0)->where('code', \Auth::user()->currency)->first();

        return view('home', ['sidebar_items' => $categories, 'sidebarHeader' => 'Categories', 'products' => $products, 'btc_price_ticker' => new Money($btc_ticker->value, new Currency(\Auth::user()->currency), true)]);
    }

    public function category($name) {
        $category = Category::where('name', $name)->first();
        $sub_cats = Category::where('parent', $category->id)->get();
        $arr = [$category->id];
        foreach ($sub_cats as $cat) {
            array_push($arr, $cat->id);
        }
        $products = Product::whereIn('category_id', $arr)->paginate(20);
        $btc_ticker = PriceTicker::where('crypto', 0)->where('code', \Auth::user()->currency)->first();

        return view('home', ['sidebar_items' => $sub_cats, 'sidebarHeader' => $category->name, 'products' => $products, 'btc_price_ticker' => new Money($btc_ticker->value, new Currency(\Auth::user()->currency), true)]);
    }

    public function vendor($name) {
        $vendor = User::where('username', $name)->first();
        $products = Product::where('vendor_id', $vendor->id)->paginate(20);
        $btc_ticker = PriceTicker::where('crypto', 0)->where('code', \Auth::user()->currency)->first();

        return view('home', ['vendor_info' => $vendor, 'sidebarHeader' => $vendor->username, 'products' => $products, 'btc_price_ticker' => new Money($btc_ticker->value, new Currency(\Auth::user()->currency), true)]);
    }
}
