<?php

namespace App\Console;

use App\Order;
use App\PriceTicker;
use Carbon\Carbon;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Storage;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        //
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->call(function () { // Update crypto prices
            $json = json_decode(Storage::disk('local')->get('currencies.json'), true);
            foreach ($json as $currency) {
                $url = "https://api.coindesk.com/v1/bpi/currentprice/".$currency['currency'].".json";
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                $_resp = curl_exec($curl);
                curl_close($curl);
                $resp = json_decode($_resp, true);
                PriceTicker::updateOrCreate(
                    ['code' => $currency['currency']], ['crypto' => 0, 'value' => $resp['bpi'][$currency['currency']]['rate_float']]
                );
            }
        })->everyMinute();

        $schedule->call(function () { // Check if orders are paid or canceled
            $orders = Order::whereIn('status', [-1, 3])->get();
            foreach ($orders as $order) {
                if (\Carbon\Carbon::now()->diff($order->updated_at)->d >= 30) {
                    $order->delete();
                }
            }
        })->everyMinute();


    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
