<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = [
        'name', 'parent'
    ];

    public function products() {
        return $this->hasMany('App\Product');
    }

    public function count_including_children()
    {
        $c = count($this->products()->get());
        $sub_cats = Category::where('parent', $this->id)->get();
        foreach ($sub_cats as $cat) {
            $c += count($cat->products()->get());
        }
        return $c;
    }
}
