package web

import (
	"git.quartzinc.dev/xiQQ/Quartz-X/auth"
	"github.com/braintree/manners"
	"github.com/gin-contrib/sessions"
	"github.com/gin-contrib/sessions/cookie"
	"github.com/gin-gonic/gin"
	"html/template"
	"log"
	"net/http"
)

const(
	userkey = "user"
)

var tpl *template.Template

func init() {
	tpl = template.Must(tpl.ParseGlob("views/*.html"))
	template.Must(tpl.ParseGlob("views/layouts/*.html"))
}

func AuthRequired(c *gin.Context){
	session := sessions.Default(c)
	user := session.Get(userkey)
	if user == nil {
		c.Redirect(302, "/auth/login")
		return
	}

	c.Next()
}


func StartWebUI(address string) *manners.GracefulServer{
	gin.SetMode(gin.ReleaseMode)
	r := gin.Default()

	server := manners.NewServer()

	r.Static("/assets", "./static/assets")

	store := cookie.NewStore([]byte("secret"))
	r.Use(sessions.Sessions("QuartzXSess", store))

	authRoutes := r.Group("/auth/")
	authRoutes.GET("/login", func(c *gin.Context) {
		if err := tpl.ExecuteTemplate(c.Writer, "auth.html", nil); err != nil {
			log.Fatalln(err.Error())
		}
	})

	authRoutes.POST("/login", func(c *gin.Context) {
		session := sessions.Default(c)
		username := c.PostForm("username")
		password := c.PostForm("password")

		if len(username) == 0 || len(password) == 0 {
			c.Set("failedLogin", true)
			c.Redirect(302, "/auth/login")
			return
		}

		if resp := auth.Login(username, password); resp.Status == "success"{
			session.Set(userkey, username)
			if err := session.Save(); err != nil {
				c.JSON(http.StatusInternalServerError, gin.H{"error":"Failed to save session"})
				return
			}
			c.Redirect(302, "/")
		}
	})

	authRoutes.POST("/register", func(c *gin.Context) {
		username := c.PostForm("username")
		password := c.PostForm("password")
		email := c.PostForm("email")
		token := c.PostForm("token")

		if len(username) == 0 || len(password) == 0 || len(email) == 0 || len(token) == 0 {
			c.Set("failedRegister", true)
			c.Redirect(302, "/auth/login")
		}

		resp := auth.Register(username, email, password, token)

		if resp.Status  == "success" {
			c.JSON(200, gin.H{"status":"registered"})
			c.Redirect(302, "/auth/login")
		}
	})


	authorized := r.Group("/", AuthRequired)
	authorized.GET("/", func(c *gin.Context) {
		if err := tpl.ExecuteTemplate(c.Writer, "dashboard.html", nil); err != nil{
			log.Fatalln(err.Error())
		}
	})




	server.Handler = r
	server.Addr = address
	err := server.ListenAndServe()
	if err != nil {
		log.Fatalln(err.Error())
	}

	return server
}