package shared

import (
	"bufio"
	"crypto/tls"
	"crypto/x509"
	"errors"
	"fmt"
	"log"
	"math/rand"
	"net/http"
	"net/url"
	"os"
	"strings"
	"time"
)

const
(
	HTTP = iota
	SOCKS4
	SOCKS5
)

func (pm *ProxyManager) Load(filename string, proxyType int) int {
	file, err := os.Open(filename)
	if err != nil {
		log.Fatal(err.Error())
		return 0
	}

	defer file.Close()
	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		line := scanner.Text()
		parts := strings.Split(line, ":")
		var p *Proxy
		if len(parts) == 4 {
			p = &Proxy{Address: fmt.Sprintf("%s:%s", parts[0], parts[1]), Auth: fmt.Sprintf("%s:%s", parts[2], parts[3]), Type: proxyType, Alive: true}
		} else {
			p = &Proxy{Address: line, Type: proxyType, Alive: true}
		}
		pm.Proxies = append(pm.Proxies, p)
	}
	return len(pm.Proxies)
}


func (pm *ProxyManager) CreateProxyTransport() *http.Transport {
	customTransport := http.DefaultTransport.(*http.Transport).Clone()
	customTransport.TLSClientConfig = &tls.Config{InsecureSkipVerify: true}
	customTransport.TLSClientConfig.VerifyPeerCertificate = func(rawCerts [][]byte, verifiedChains [][]*x509.Certificate) error {
		return nil
	}

	customTransport.IdleConnTimeout = 2 * time.Second
	customTransport.MaxIdleConns = 5

	customTransport.Proxy = pm.GetRandomProxy

	return customTransport
}

func (pm *ProxyManager) GetRandomProxy(r *http.Request) (*url.URL, error) {
	if len(pm.Proxies) == 0 {
		return nil, errors.New("Theres no proxies!")
	}

	var proxy *Proxy
	var scheme string

	if len(pm.Proxies) == 1 {
		proxy = pm.Proxies[0]
	}else {
		proxy = pm.Proxies[rand.Intn(len(pm.Proxies)-1)]
	}

	switch proxy.Type {
	case HTTP:
		scheme = "http"
		break
	case SOCKS4:
		scheme = "socks4"
		break
	case SOCKS5:
		scheme = "socks5"
		break
	}

	_u, err := url.Parse(fmt.Sprintf("%s://%s", scheme, proxy.Address))
	if err != nil {
		return nil, err
	}

	if len(proxy.Auth) > 0 {
		_u.User = url.UserPassword(strings.Split(proxy.Auth, ":")[0], strings.Split(proxy.Auth, ":")[1])
	}

	return _u, nil
}



func (c *ComboManager)LoadCredentials(){
	// not done yet
}