package modules

import "git.quartzinc.dev/xiQQ/Quartz-X/shared"

var MManager *ModulesManager

type ModulesManager struct {
	Modules map[string]*Module
}

type Module struct {
	Hits int
	Bads int
	Retries int
	PManager *shared.ProxyManager
	CManager *shared.ComboManager
	CheckFunction func(cred *shared.Combo) error
	Threads int
}

func ModulesInit(){
	MManager.Modules = map[string]*Module{}
}


func (m *ModulesManager) AddModule(name string, checkFunc func(cred *shared.Combo) error){
	m.Modules[name] = &Module{
		Hits:     0,
		Bads:     0,
		Retries:  0,
		PManager: &shared.ProxyManager{Proxies: []*shared.Proxy{}},
		CManager: &shared.ComboManager{Credentials: []*shared.Combo{}},
		CheckFunction: checkFunc,
		Threads: 0,
	}
}

func (m *ModulesManager) StartModule(name string, threads int){

	comboChan := make(chan *shared.Combo)
	sem := make(chan interface{}, threads)

	// Handles Checking
	for i := 0; i < threads; i++{
		sem <- 0
		go func() {

			defer func() {
				<-sem
			}()

			for credential := range comboChan{
				err := m.Modules[name].CheckFunction(credential)
				if err != nil{
					//do something
				}
			}
		}()
	}

	//Handles forward to Checking
	go func(){
		for _, credential := range m.Modules[name].CManager.Credentials{
			comboChan <- credential
		}
	}()

	//Handles Combos
	go func() {

	}()

}

