package auth

import (
	"fmt"
	"git.quartzinc.dev/Zertex/XDGv2/utils"
	"git.quartzinc.dev/xiQQ/Quartz-X/api/client"
	"git.quartzinc.dev/xiQQ/Quartz-X/apiproto"
	"time"
)

var
(
	Version = "1.0"
	Expiry time.Time
	ClientUsername = ""
	Password = ""
)

func Login(username string, password string) apiproto.AuthResponse {
	utils.LogInfo("Authenticating..")
	if err := client.QuartzXAPI.Login(username, password, Version); err != nil {
		fmt.Println(err.Error())
		return apiproto.AuthResponse{}
	}

	resp := <- client.QuartzXAPI.Auth()

	ClientUsername = username
	Password = password
	Expiry = resp.Expiry

	return resp
}

func Register(username string, email string, password string, token string) apiproto.AuthResponse {
	err := client.QuartzXAPI.Register(username, password, email, token, Version)
	if err != nil {
		return apiproto.AuthResponse{}
	}

	resp := <- client.QuartzXAPI.Auth()
	ClientUsername = username
	Password = password
	Expiry = resp.Expiry

	return resp
}

func Renew(username string, password string, token string) apiproto.AuthResponse {
	err := client.QuartzXAPI.Redeem(username, password, token, Version)
	if err != nil {
		return apiproto.AuthResponse{}
	}

	return <- client.QuartzXAPI.Auth()
}

func Var(name string) string {
	err := client.QuartzXAPI.Var(ClientUsername, Password, name, Version)
	if err != nil {
		return ""
	}
	fmt.Println("Waiting on response")
	if resp := <- client.QuartzXAPI.Auth(); resp.Status == "success" {
		return resp.Data
	}
	return ""
}

func AVar() map[string]string {
	err := client.QuartzXAPI.Var(ClientUsername, Password, "all", Version)
	if err != nil {
		return nil
	}


	if resp := <- client.QuartzXAPI.Auth(); resp.Status == "success" {
		return resp.ArrData
	}
	return nil
}

func Heartbeat() bool {
	err := client.QuartzXAPI.Heartbeat()
	if err != nil {
		return false
	}

	resp := <- client.QuartzXAPI.Auth()
	if resp.Status == "failure" {
		utils.LogError("Somethings fishy...")
		return false
	}
	return true
}
