package main

import (
	"bufio"
	"encoding/hex"
	"fmt"
	"net"
)

func (p *Proxy)ServerBridge(){
	conn, err := net.Dial("tcp", p.ServerAddress)
	defer conn.Close()
	if err != nil{
		panic(err)
	}

	fmt.Println(fmt.Sprintf("[Server](%s)- Connection Established", p.ServerAddress))

	for {
		_, err := conn.Write(<- p.ToServerChan)

		message, err := bufio.NewReader(conn).ReadString('\n')
		if err != nil{
			panic(err)
		}

		//debugging purposes
		fmt.Println("[SERVER]-",message)

		p.ToClientChan <- []byte(message)

		data := <- p.ToServerChan
		_, err = conn.Write(data)
		if err != nil{
			panic(err)
		}

		fmt.Println(fmt.Sprintf("[Client(%s) --> Server(%s)]- %s", p.ClientPort, p.ServerAddress, hex.EncodeToString(data[0:100])))

	}
}

func (p *Proxy) ClientBridge(){
	ln, err := net.Listen("tcp", p.ClientPort)
	if err != nil{
		panic(err)
	}
	fmt.Println(fmt.Sprintf("[Listening](port %s)", p.ClientPort))

	conn, err := ln.Accept()
	defer conn.Close()
	if err != nil{
		panic(err)
	}

	fmt.Println(fmt.Sprintf("[Client](port %s)- Connection Established", p.ClientPort))

	for {
		message, err := bufio.NewReader(conn).ReadString('\n')
		if err != nil{
			panic(err)
		}

		//debugging purposes
		fmt.Println("[CLIENT]-",message)

		p.ToServerChan <- []byte(message)

		data := <- p.ToClientChan
		_, err = conn.Write(data)
		if err != nil{
			panic(err)
		}

		fmt.Println(fmt.Sprintf("[Server --> Client](port %s)- %s", p.ClientPort), hex.EncodeToString(data[0:100]))
	}
}
