function cull_indicator()
	local current_indicator = item.get_var("current_indicator")
	item.set_var("current_indicator", nil)
	if current_indicator ~= nil then
		TBOE.destroy_instance(current_indicator)
	end
end

function update_indicator(nearest_job)
	cull_indicator()
	
	if nearest_job.exists() then
		local new_indicator = TBOE.instantiate(objects.offscreen_indicator)
		TBOE.deploy_instance(new_indicator, wearer.global_position)
		new_indicator.set_var("objective", nearest_job)
		new_indicator.set_var("player", wearer)
		item.set_var("current_indicator", new_indicator)
		item.set_var("nearest_job", nearest_job)
	end
end

if item.is_worn then
	local nearest_job = TBOE.get_nearest_group_member("janny_jobs", wearer.global_position)
	if not nearest_job.exists() then
		local current_indicator = item.get_var("current_indicator", nil)
		if current_indicator ~= nil and not current_indicator.exists() then
			cull_indicator()
		end
	else
		local item_nearest_job = item.get_var("nearest_job", nil)
		if item_nearest_job == nil or nearest_job.id ~= item_nearest_job.id then
			update_indicator(nearest_job)
		end
	end
end