% single_factor_example
close all;

wVec = 0:.001:(2*pi);

r = .9;
t = 0;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

figure(1);
subplot(3,1,1);
plot(wVec,gain,'lineWidth',2);
ylabel('Gain (db)');
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
title('Gain')
hold on;
subplot(3,1,2);
plot(wVec,phase,'lineWidth',2);
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
ylabel('Phase (rad)');
title('Phase');
hold on;
subplot(3,1,3);
plot(wVec,grd,'lineWidth',2);
title('Group Delay');
ylabel('Group Delay (samples)'); 
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
hold on;
pause;

r = .9;
t = pi / 2;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

subplot(3,1,1);
plot(wVec,gain,'r-','lineWidth',2);
title('Gain');
ylabel('Gain (db)');
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
subplot(3,1,2);
plot(wVec,phase,'r-','lineWidth',2);
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
ylabel('Phase (rad)');
title('Phase');
subplot(3,1,3);
plot(wVec,grd,'r-','lineWidth',2);
title('Group Delay');
ylabel('Group Delay (samples)'); 
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
pause;

r = .9;
t = pi;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

subplot(3,1,1);
plot(wVec,gain,'g-','lineWidth',2);
title('Gain')
legend('\theta = 0','\theta = \pi/2','\theta = \pi');
subplot(3,1,2);
plot(wVec,phase,'g-','lineWidth',2);
title('Phase');
legend('\theta = 0','\theta = \pi/2','\theta = \pi');
subplot(3,1,3);
plot(wVec,grd,'g-','lineWidth',2);
title('Group Delay');
legend('\theta = 0','\theta = \pi/2','\theta = \pi');
pause;



figure(2);

r = .99;
t = pi;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

subplot(3,1,1);
plot(wVec,gain,'g-','lineWidth',2);
ylabel('Gain (db)');
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
title('Gain')
hold on;
subplot(3,1,2);
plot(wVec,phase,'g-','lineWidth',2);
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
ylabel('Phase (rad)');
title('Phase');
hold on;
subplot(3,1,3);
plot(wVec,grd,'g-','lineWidth',2);
title('Group Delay');
ylabel('Group Delay (samples)'); 
set(gca,'xtick',[0,pi/2,pi,3*pi/2,2*pi]);
set(gca,'xticklabels',{'0','\pi/2','\pi','3 \pi/2','2 \pi'});
hold on;
pause;


r = .9;
t = pi;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

subplot(3,1,1);
plot(wVec,gain,'b-','lineWidth',2);
title('Gain')
subplot(3,1,2);
plot(wVec,phase,'b-','lineWidth',2);
title('Phase');
subplot(3,1,3);
plot(wVec,grd,'b-','lineWidth',2);
title('Group Delay');
pause;

r = .7;
t = pi;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

subplot(3,1,1);
plot(wVec,gain,'r-','lineWidth',2);
title('Gain')
subplot(3,1,2);
plot(wVec,phase,'r-','lineWidth',2);
title('Phase');
subplot(3,1,3);
plot(wVec,grd,'r-','lineWidth',2);
title('Group Delay');
pause;


r = .5;
t = pi;

gain  = 20 * log10( 1 + r^2 - 2*r*cos(wVec - t) );
phase = atan( (r * sin(wVec - t)) ./ ( 1 - r * cos(wVec - t) ) );
grd   = ( r^2 - r * cos( wVec - t ) ) ./ ( 1 + r^2 - 2 * r * cos( wVec - t ) );

subplot(3,1,1);
plot(wVec,gain,'k-','lineWidth',2);
title('Gain')
legend('r = .99','r = .9','r = .7','r = .5');
subplot(3,1,2);
plot(wVec,phase,'k-','lineWidth',2);
title('Phase');
legend('r = .99','r = .9','r = .7','r = .5');
subplot(3,1,3);
plot(wVec,grd,'k-','lineWidth',2);
title('Group Delay');
legend('r = .99','r = .9','r = .7','r = .5');
pause;
